Imports System.Data.OleDb

Module Module1
    Public Sub PrintTable(ByVal ds As DataSet)
        ' Afficher les rsultats de la table.
        Console.WriteLine("Voici ce que nous avons maintenant:")
        Dim invTable As DataTable = ds.Tables("Inventory")

        ' Afficher le nom des colonnes.
        Dim curCol As Integer
        For curCol = 0 To invTable.Columns.Count - 1
            Console.Write(invTable.Columns(curCol).ColumnName.Trim() & vbTab)
        Next
        Console.WriteLine()

        ' Afficher chaque cellule.
        Dim curRow As Integer
        For curRow = 0 To invTable.Rows.Count - 1
            For curCol = 0 To invTable.Columns.Count - 1
                Console.Write(invTable.Rows(curRow)(curCol).ToString().Trim() & vbTab)
            Next
            Console.WriteLine()
        Next
        Console.WriteLine()
    End Sub

    Sub Main()
        ' Etape 1: Ouvrir une connexion.			
        Dim cn As OleDbConnection = New OleDbConnection()
        cn.ConnectionString = "Provider=SQLOLEDB.1;" & _
         "Integrated Security=SSPI;" & _
         "Persist Security Info=False;" & _
         "Initial Catalog=Cars;" & _
         "Data Source=(local);"
        cn.Open()

        ' Etape 2: Crer des commandes SELECT et UPDATE.
        ' Crer une commande SELECT.
        Dim selectCmd As OleDbCommand = New OleDbCommand("SELECT * FROM Inventory", cn)

        ' Etape 3: Crer un adaptateur de donnes et des commandes associes.
        Dim dAdapt As OleDbDataAdapter = New OleDbDataAdapter()
        dAdapt.SelectCommand = selectCmd

        ' Etape 4: Crer et remplir l'objet DataSet, fermer la connexion.
        Dim myDS As DataSet = New DataSet("CarsDataSet")
        Try
            dAdapt.Fill(myDS, "Inventory")
        Catch ex As Exception
            Console.WriteLine(ex.Message)
        Finally
            cn.Close()
        End Try

        ' Afficher ce que nous avons.
        PrintTable(myDS)
    End Sub
End Module
